#ifndef __CMouse__
#define __CMouse__

#include <MathTools/CPoint.hpp>
#include "CCursor.hpp"
#include "SWindowHandle.hpp"

//	===========================================================================

using Exponent::MathTools::CPoint;
using Exponent::GUI::Windowing::CCursor;
using Exponent::GUI::Windowing::SWindowHandle;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Windowing
		{
			/**
			 * @class CMouse CMouse.hpp
			 * @brief A mouse representation
			 *
			 * @date 19/09/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CMouse.hpp,v 1.4 2007/02/08 21:07:54 paul Exp $
			 */
			class CMouse
			{
			public:

//	===========================================================================

				/**
				 * Construction
				 * @param point The mouse position
				 * @param cursor The cursor to use
				 */
				CMouse(const CPoint &point, CCursor *cursor = &CCursor::CCURSOR_ARROW);

				/** @cond */
				#ifdef WIN32
				/** @endcond */
					/**
					 * Construction
					 * @param lParam The mouse position as a window LPARAM
					 * @param cursor The cursor to use
					 */
					CMouse(LPARAM lParam, CCursor *cursor = &CCursor::CCURSOR_ARROW);
				/** @cond */
				#endif
				/** @endcond */

				/**
				 * Construction
				 */
				CMouse();

				/**
				 * Destruction
				 */
				virtual ~CMouse();

//	===========================================================================

				/**
				 * Set the cursor
				 * @param cursor The cursor to use
				 */
				void setCursor(CCursor *cursor = &CCursor::CCURSOR_ARROW);

				/**
				 * Get the cursor
				 * @retval CCursor* The cursor that is being used
				 */
				CCursor *getCursor() const { return m_cursor; }

//	===========================================================================

				/**
				 * Set the position of the mouse
				 * @param point The mouse position
				 */
				void setPosition(const CPoint &point);

				/** @cond */
				#ifdef WIN32
				/** @endcond */
					/**
					 * Set the position
					 * @param lParam The mouse position as a window LPARAM
					 */
					void setPosition(LPARAM lParam);
				/** @cond */
				#endif
				/** @endcond */

				/**
				 * Get the position
				 * @retval const CPoint& The position of the mouse
				 */
				const CPoint &getPosition() const { return m_position; }

				/**
				 * Get the xposition
				 * @retval long The X Position of the mouse
				 */
				long getXPosition() const { return m_position.getXPosition(); }

				/**
				 * Get the y position
				 * @retval long The Y Position of the mouse
				 */
				long getYPosition() const { return m_position.getYPosition(); }

//	===========================================================================

				/**
				 * Capture the mouse
				 * @param windowHandle The window to capture
				 */
				void capture(SWindowHandle *windowHandle) const;

				/**
				 * Check if the mouse is captured by a specific window
				 * @param windowHandle The window to check against
				 * @retval bool True if captured, false otherwise
				 */
				bool isCaptured(SWindowHandle *windowHandle) const;

				/**
				 * Release the mouse
				 */
				void release() const;

				/**
				 * Check if the mouse is captured
				 * @retval bool True if captured, false otherwise
				 */
				bool isCaptured() const;

//	===========================================================================

			protected:

//	===========================================================================

				CPoint m_position;		/**< The mouse position */
				CCursor *m_cursor;		/**< The cursor */
			};
		}
	}
}
#endif	// End of CCursor.hpp